package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.{MaxDataCatalogsCount, Token}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDataCatalogsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxDataCatalogsCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest = {
    import ListDataCatalogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxDataCatalogsCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListDataCatalogsRequest.ReadOnly =
    zio.aws.athena.model.ListDataCatalogsRequest.wrap(buildAwsValue())
}
object ListDataCatalogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListDataCatalogsRequest =
      zio.aws.athena.model.ListDataCatalogsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxDataCatalogsCount]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxDataCatalogsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
  ) extends zio.aws.athena.model.ListDataCatalogsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Option[MaxDataCatalogsCount] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxDataCatalogsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
  ): zio.aws.athena.model.ListDataCatalogsRequest.ReadOnly = new Wrapper(impl)
}
