package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDatabasesResponse(
    databaseList: Option[Iterable[zio.aws.athena.model.Database]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListDatabasesResponse = {
    import ListDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListDatabasesResponse
      .builder()
      .optionallyWith(
        databaseList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databaseList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListDatabasesResponse.ReadOnly =
    zio.aws.athena.model.ListDatabasesResponse.wrap(buildAwsValue())
}
object ListDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListDatabasesResponse =
      zio.aws.athena.model.ListDatabasesResponse(
        databaseList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def databaseList: Option[List[zio.aws.athena.model.Database.ReadOnly]]
    def nextToken: Option[Token]
    def getDatabaseList
        : ZIO[Any, AwsError, List[zio.aws.athena.model.Database.ReadOnly]] =
      AwsError.unwrapOptionField("databaseList", databaseList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListDatabasesResponse
  ) extends zio.aws.athena.model.ListDatabasesResponse.ReadOnly {
    override val databaseList
        : Option[List[zio.aws.athena.model.Database.ReadOnly]] = scala
      .Option(impl.databaseList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.Database.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListDatabasesResponse
  ): zio.aws.athena.model.ListDatabasesResponse.ReadOnly = new Wrapper(impl)
}
