package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEngineVersionsResponse(
    engineVersions: Option[Iterable[zio.aws.athena.model.EngineVersion]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse = {
    import ListEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse
      .builder()
      .optionallyWith(
        engineVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineVersions)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly =
    zio.aws.athena.model.ListEngineVersionsResponse.wrap(buildAwsValue())
}
object ListEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListEngineVersionsResponse =
      zio.aws.athena.model.ListEngineVersionsResponse(
        engineVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def engineVersions
        : Option[List[zio.aws.athena.model.EngineVersion.ReadOnly]]
    def nextToken: Option[Token]
    def getEngineVersions: ZIO[Any, AwsError, List[
      zio.aws.athena.model.EngineVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("engineVersions", engineVersions)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse
  ) extends zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly {
    override val engineVersions
        : Option[List[zio.aws.athena.model.EngineVersion.ReadOnly]] = scala
      .Option(impl.engineVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.EngineVersion.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse
  ): zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
