package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  Date,
  WorkGroupName,
  DescriptionString,
  QueryString,
  StatementName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PreparedStatement(
    statementName: Option[StatementName] = None,
    queryStatement: Option[QueryString] = None,
    workGroupName: Option[WorkGroupName] = None,
    description: Option[DescriptionString] = None,
    lastModifiedTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.PreparedStatement = {
    import PreparedStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.PreparedStatement
      .builder()
      .optionallyWith(
        statementName.map(value =>
          StatementName.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(
        queryStatement.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryStatement)
      .optionallyWith(
        workGroupName.map(value =>
          WorkGroupName.unwrap(value): java.lang.String
        )
      )(_.workGroupName)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        lastModifiedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.PreparedStatement.ReadOnly =
    zio.aws.athena.model.PreparedStatement.wrap(buildAwsValue())
}
object PreparedStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.PreparedStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.PreparedStatement =
      zio.aws.athena.model.PreparedStatement(
        statementName.map(value => value),
        queryStatement.map(value => value),
        workGroupName.map(value => value),
        description.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def statementName: Option[StatementName]
    def queryStatement: Option[QueryString]
    def workGroupName: Option[WorkGroupName]
    def description: Option[DescriptionString]
    def lastModifiedTime: Option[Date]
    def getStatementName: ZIO[Any, AwsError, StatementName] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getQueryStatement: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryStatement", queryStatement)
    def getWorkGroupName: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroupName", workGroupName)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.PreparedStatement
  ) extends zio.aws.athena.model.PreparedStatement.ReadOnly {
    override val statementName: Option[StatementName] = scala
      .Option(impl.statementName())
      .map(value => zio.aws.athena.model.primitives.StatementName(value))
    override val queryStatement: Option[QueryString] = scala
      .Option(impl.queryStatement())
      .map(value => zio.aws.athena.model.primitives.QueryString(value))
    override val workGroupName: Option[WorkGroupName] = scala
      .Option(impl.workGroupName())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val lastModifiedTime: Option[Date] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.PreparedStatement
  ): zio.aws.athena.model.PreparedStatement.ReadOnly = new Wrapper(impl)
}
