package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait QueryExecutionState {
  def unwrap: software.amazon.awssdk.services.athena.model.QueryExecutionState
}
object QueryExecutionState {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.QueryExecutionState
  ): zio.aws.athena.model.QueryExecutionState = value match {
    case software.amazon.awssdk.services.athena.model.QueryExecutionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.QueryExecutionState.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.athena.model.QueryExecutionState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.athena.model.QueryExecutionState.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.athena.model.QueryExecutionState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.athena.model.QueryExecutionState.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.athena.model.QueryExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.QueryExecutionState =
      software.amazon.awssdk.services.athena.model.QueryExecutionState.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.athena.model.QueryExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.QueryExecutionState =
      software.amazon.awssdk.services.athena.model.QueryExecutionState.QUEUED
  }
  case object RUNNING extends zio.aws.athena.model.QueryExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.QueryExecutionState =
      software.amazon.awssdk.services.athena.model.QueryExecutionState.RUNNING
  }
  case object SUCCEEDED extends zio.aws.athena.model.QueryExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.QueryExecutionState =
      software.amazon.awssdk.services.athena.model.QueryExecutionState.SUCCEEDED
  }
  case object FAILED extends zio.aws.athena.model.QueryExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.QueryExecutionState =
      software.amazon.awssdk.services.athena.model.QueryExecutionState.FAILED
  }
  case object CANCELLED extends zio.aws.athena.model.QueryExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.QueryExecutionState =
      software.amazon.awssdk.services.athena.model.QueryExecutionState.CANCELLED
  }
}
