package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResultConfiguration(
    outputLocation: Option[String] = None,
    encryptionConfiguration: Option[
      zio.aws.athena.model.EncryptionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultConfiguration = {
    import ResultConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultConfiguration
      .builder()
      .optionallyWith(outputLocation.map(value => value: java.lang.String))(
        _.outputLocation
      )
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultConfiguration.ReadOnly =
    zio.aws.athena.model.ResultConfiguration.wrap(buildAwsValue())
}
object ResultConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultConfiguration =
      zio.aws.athena.model.ResultConfiguration(
        outputLocation.map(value => value),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def outputLocation: Option[String]
    def encryptionConfiguration
        : Option[zio.aws.athena.model.EncryptionConfiguration.ReadOnly]
    def getOutputLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultConfiguration
  ) extends zio.aws.athena.model.ResultConfiguration.ReadOnly {
    override val outputLocation: Option[String] =
      scala.Option(impl.outputLocation()).map(value => value: String)
    override val encryptionConfiguration
        : Option[zio.aws.athena.model.EncryptionConfiguration.ReadOnly] = scala
      .Option(impl.encryptionConfiguration())
      .map(value => zio.aws.athena.model.EncryptionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultConfiguration
  ): zio.aws.athena.model.ResultConfiguration.ReadOnly = new Wrapper(impl)
}
