package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResultSet(
    rows: Option[Iterable[zio.aws.athena.model.Row]] = None,
    resultSetMetadata: Option[zio.aws.athena.model.ResultSetMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultSet = {
    import ResultSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultSet
      .builder()
      .optionallyWith(
        rows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rows)
      .optionallyWith(resultSetMetadata.map(value => value.buildAwsValue()))(
        _.resultSetMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultSet.ReadOnly =
    zio.aws.athena.model.ResultSet.wrap(buildAwsValue())
}
object ResultSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.ResultSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultSet =
      zio.aws.athena.model.ResultSet(
        rows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultSetMetadata.map(value => value.asEditable)
      )
    def rows: Option[List[zio.aws.athena.model.Row.ReadOnly]]
    def resultSetMetadata
        : Option[zio.aws.athena.model.ResultSetMetadata.ReadOnly]
    def getRows: ZIO[Any, AwsError, List[zio.aws.athena.model.Row.ReadOnly]] =
      AwsError.unwrapOptionField("rows", rows)
    def getResultSetMetadata
        : ZIO[Any, AwsError, zio.aws.athena.model.ResultSetMetadata.ReadOnly] =
      AwsError.unwrapOptionField("resultSetMetadata", resultSetMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultSet
  ) extends zio.aws.athena.model.ResultSet.ReadOnly {
    override val rows: Option[List[zio.aws.athena.model.Row.ReadOnly]] = scala
      .Option(impl.rows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.Row.wrap(item)
        }.toList
      )
    override val resultSetMetadata
        : Option[zio.aws.athena.model.ResultSetMetadata.ReadOnly] = scala
      .Option(impl.resultSetMetadata())
      .map(value => zio.aws.athena.model.ResultSetMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultSet
  ): zio.aws.athena.model.ResultSet.ReadOnly = new Wrapper(impl)
}
