package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResultSetMetadata(
    columnInfo: Option[Iterable[zio.aws.athena.model.ColumnInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultSetMetadata = {
    import ResultSetMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultSetMetadata
      .builder()
      .optionallyWith(
        columnInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnInfo)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultSetMetadata.ReadOnly =
    zio.aws.athena.model.ResultSetMetadata.wrap(buildAwsValue())
}
object ResultSetMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultSetMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultSetMetadata =
      zio.aws.athena.model.ResultSetMetadata(
        columnInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def columnInfo: Option[List[zio.aws.athena.model.ColumnInfo.ReadOnly]]
    def getColumnInfo
        : ZIO[Any, AwsError, List[zio.aws.athena.model.ColumnInfo.ReadOnly]] =
      AwsError.unwrapOptionField("columnInfo", columnInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultSetMetadata
  ) extends zio.aws.athena.model.ResultSetMetadata.ReadOnly {
    override val columnInfo
        : Option[List[zio.aws.athena.model.ColumnInfo.ReadOnly]] = scala
      .Option(impl.columnInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.ColumnInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultSetMetadata
  ): zio.aws.athena.model.ResultSetMetadata.ReadOnly = new Wrapper(impl)
}
