package zio.aws.athena.model
import zio.aws.athena.model.primitives.QueryExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopQueryExecutionRequest(queryExecutionId: QueryExecutionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest = {
    import StopQueryExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest
      .builder()
      .queryExecutionId(
        QueryExecutionId.unwrap(queryExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.StopQueryExecutionRequest.ReadOnly =
    zio.aws.athena.model.StopQueryExecutionRequest.wrap(buildAwsValue())
}
object StopQueryExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StopQueryExecutionRequest =
      zio.aws.athena.model.StopQueryExecutionRequest(queryExecutionId)
    def queryExecutionId: QueryExecutionId
    def getQueryExecutionId: ZIO[Any, Nothing, QueryExecutionId] =
      ZIO.succeed(queryExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest
  ) extends zio.aws.athena.model.StopQueryExecutionRequest.ReadOnly {
    override val queryExecutionId: QueryExecutionId =
      zio.aws.athena.model.primitives.QueryExecutionId(impl.queryExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest
  ): zio.aws.athena.model.StopQueryExecutionRequest.ReadOnly = new Wrapper(impl)
}
