package zio.aws.athena.model
import zio.aws.athena.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: AmazonResourceName,
    tags: Iterable[zio.aws.athena.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.TagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.TagResourceRequest.ReadOnly =
    zio.aws.athena.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.TagResourceRequest =
      zio.aws.athena.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: AmazonResourceName
    def tags: List[zio.aws.athena.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.athena.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.TagResourceRequest
  ) extends zio.aws.athena.model.TagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.athena.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tags: List[zio.aws.athena.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.athena.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.TagResourceRequest
  ): zio.aws.athena.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
