package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ErrorMessage,
  ErrorCode,
  QueryExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UnprocessedQueryExecutionId(
    queryExecutionId: Option[QueryExecutionId] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId = {
    import UnprocessedQueryExecutionId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId
      .builder()
      .optionallyWith(
        queryExecutionId.map(value =>
          QueryExecutionId.unwrap(value): java.lang.String
        )
      )(_.queryExecutionId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UnprocessedQueryExecutionId.ReadOnly =
    zio.aws.athena.model.UnprocessedQueryExecutionId.wrap(buildAwsValue())
}
object UnprocessedQueryExecutionId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UnprocessedQueryExecutionId =
      zio.aws.athena.model.UnprocessedQueryExecutionId(
        queryExecutionId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def queryExecutionId: Option[QueryExecutionId]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getQueryExecutionId: ZIO[Any, AwsError, QueryExecutionId] =
      AwsError.unwrapOptionField("queryExecutionId", queryExecutionId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId
  ) extends zio.aws.athena.model.UnprocessedQueryExecutionId.ReadOnly {
    override val queryExecutionId: Option[QueryExecutionId] = scala
      .Option(impl.queryExecutionId())
      .map(value => zio.aws.athena.model.primitives.QueryExecutionId(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.athena.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.athena.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId
  ): zio.aws.athena.model.UnprocessedQueryExecutionId.ReadOnly = new Wrapper(
    impl
  )
}
