package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  Date,
  WorkGroupDescriptionString,
  WorkGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class WorkGroupSummary(
    name: Option[WorkGroupName] = None,
    state: Option[zio.aws.athena.model.WorkGroupState] = None,
    description: Option[WorkGroupDescriptionString] = None,
    creationTime: Option[Date] = None,
    engineVersion: Option[zio.aws.athena.model.EngineVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.WorkGroupSummary = {
    import WorkGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.WorkGroupSummary
      .builder()
      .optionallyWith(
        name.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          WorkGroupDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.WorkGroupSummary.ReadOnly =
    zio.aws.athena.model.WorkGroupSummary.wrap(buildAwsValue())
}
object WorkGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.WorkGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.WorkGroupSummary =
      zio.aws.athena.model.WorkGroupSummary(
        name.map(value => value),
        state.map(value => value),
        description.map(value => value),
        creationTime.map(value => value),
        engineVersion.map(value => value.asEditable)
      )
    def name: Option[WorkGroupName]
    def state: Option[zio.aws.athena.model.WorkGroupState]
    def description: Option[WorkGroupDescriptionString]
    def creationTime: Option[Date]
    def engineVersion: Option[zio.aws.athena.model.EngineVersion.ReadOnly]
    def getName: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.WorkGroupState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, WorkGroupDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupSummary
  ) extends zio.aws.athena.model.WorkGroupSummary.ReadOnly {
    override val name: Option[WorkGroupName] = scala
      .Option(impl.name())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val state: Option[zio.aws.athena.model.WorkGroupState] = scala
      .Option(impl.state())
      .map(value => zio.aws.athena.model.WorkGroupState.wrap(value))
    override val description: Option[WorkGroupDescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.athena.model.primitives.WorkGroupDescriptionString(value)
      )
    override val creationTime: Option[Date] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val engineVersion
        : Option[zio.aws.athena.model.EngineVersion.ReadOnly] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupSummary
  ): zio.aws.athena.model.WorkGroupSummary.ReadOnly = new Wrapper(impl)
}
