package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait BackupJobState {
  def unwrap: software.amazon.awssdk.services.backup.model.BackupJobState
}
object BackupJobState {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.BackupJobState
  ): zio.aws.backup.model.BackupJobState = value match {
    case software.amazon.awssdk.services.backup.model.BackupJobState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.ABORTING =>
      val r = ABORTING
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.ABORTED =>
      val r = ABORTED
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.backup.model.BackupJobState.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.CREATED
  }
  case object PENDING extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.PENDING
  }
  case object RUNNING extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.RUNNING
  }
  case object ABORTING extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.ABORTING
  }
  case object ABORTED extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.ABORTED
  }
  case object COMPLETED extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.COMPLETED
  }
  case object FAILED extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.FAILED
  }
  case object EXPIRED extends zio.aws.backup.model.BackupJobState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupJobState =
      software.amazon.awssdk.services.backup.model.BackupJobState.EXPIRED
  }
}
