package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{BackupPlanName, Timestamp, ARN}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BackupPlansListMember(
    backupPlanArn: Option[ARN] = None,
    backupPlanId: Option[String] = None,
    creationDate: Option[Timestamp] = None,
    deletionDate: Option[Timestamp] = None,
    versionId: Option[String] = None,
    backupPlanName: Option[BackupPlanName] = None,
    creatorRequestId: Option[String] = None,
    lastExecutionDate: Option[Timestamp] = None,
    advancedBackupSettings: Option[
      Iterable[zio.aws.backup.model.AdvancedBackupSetting]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupPlansListMember = {
    import BackupPlansListMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupPlansListMember
      .builder()
      .optionallyWith(
        backupPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupPlanArn)
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        deletionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(
        backupPlanName.map(value =>
          BackupPlanName.unwrap(value): java.lang.String
        )
      )(_.backupPlanName)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(
        lastExecutionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.advancedBackupSettings)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupPlansListMember.ReadOnly =
    zio.aws.backup.model.BackupPlansListMember.wrap(buildAwsValue())
}
object BackupPlansListMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.BackupPlansListMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupPlansListMember =
      zio.aws.backup.model.BackupPlansListMember(
        backupPlanArn.map(value => value),
        backupPlanId.map(value => value),
        creationDate.map(value => value),
        deletionDate.map(value => value),
        versionId.map(value => value),
        backupPlanName.map(value => value),
        creatorRequestId.map(value => value),
        lastExecutionDate.map(value => value),
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupPlanArn: Option[ARN]
    def backupPlanId: Option[String]
    def creationDate: Option[Timestamp]
    def deletionDate: Option[Timestamp]
    def versionId: Option[String]
    def backupPlanName: Option[BackupPlanName]
    def creatorRequestId: Option[String]
    def lastExecutionDate: Option[Timestamp]
    def advancedBackupSettings
        : Option[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]]
    def getBackupPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDeletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getVersionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getBackupPlanName: ZIO[Any, AwsError, BackupPlanName] =
      AwsError.unwrapOptionField("backupPlanName", backupPlanName)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getLastExecutionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getAdvancedBackupSettings: ZIO[Any, AwsError, List[
      zio.aws.backup.model.AdvancedBackupSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "advancedBackupSettings",
      advancedBackupSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupPlansListMember
  ) extends zio.aws.backup.model.BackupPlansListMember.ReadOnly {
    override val backupPlanArn: Option[ARN] = scala
      .Option(impl.backupPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val backupPlanId: Option[String] =
      scala.Option(impl.backupPlanId()).map(value => value: String)
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deletionDate: Option[Timestamp] = scala
      .Option(impl.deletionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val versionId: Option[String] =
      scala.Option(impl.versionId()).map(value => value: String)
    override val backupPlanName: Option[BackupPlanName] = scala
      .Option(impl.backupPlanName())
      .map(value => zio.aws.backup.model.primitives.BackupPlanName(value))
    override val creatorRequestId: Option[String] =
      scala.Option(impl.creatorRequestId()).map(value => value: String)
    override val lastExecutionDate: Option[Timestamp] = scala
      .Option(impl.lastExecutionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val advancedBackupSettings
        : Option[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]] =
      scala
        .Option(impl.advancedBackupSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.AdvancedBackupSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupPlansListMember
  ): zio.aws.backup.model.BackupPlansListMember.ReadOnly = new Wrapper(impl)
}
