package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  BackupRuleName,
  BackupVaultName,
  TagValue,
  CronExpression,
  WindowMinutes,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class BackupRule(
    ruleName: BackupRuleName,
    targetBackupVaultName: BackupVaultName,
    scheduleExpression: Option[CronExpression] = None,
    startWindowMinutes: Option[WindowMinutes] = None,
    completionWindowMinutes: Option[WindowMinutes] = None,
    lifecycle: Option[zio.aws.backup.model.Lifecycle] = None,
    recoveryPointTags: Option[Map[TagKey, TagValue]] = None,
    ruleId: Option[String] = None,
    copyActions: Option[Iterable[zio.aws.backup.model.CopyAction]] = None,
    enableContinuousBackup: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupRule = {
    import BackupRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupRule
      .builder()
      .ruleName(BackupRuleName.unwrap(ruleName): java.lang.String)
      .targetBackupVaultName(
        BackupVaultName.unwrap(targetBackupVaultName): java.lang.String
      )
      .optionallyWith(
        scheduleExpression.map(value =>
          CronExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        startWindowMinutes.map(value =>
          WindowMinutes.unwrap(value): java.lang.Long
        )
      )(_.startWindowMinutes)
      .optionallyWith(
        completionWindowMinutes.map(value =>
          WindowMinutes.unwrap(value): java.lang.Long
        )
      )(_.completionWindowMinutes)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(
        recoveryPointTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.recoveryPointTags)
      .optionallyWith(ruleId.map(value => value: java.lang.String))(_.ruleId)
      .optionallyWith(
        copyActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.copyActions)
      .optionallyWith(
        enableContinuousBackup.map(value => value: java.lang.Boolean)
      )(_.enableContinuousBackup)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupRule.ReadOnly =
    zio.aws.backup.model.BackupRule.wrap(buildAwsValue())
}
object BackupRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.BackupRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupRule =
      zio.aws.backup.model.BackupRule(
        ruleName,
        targetBackupVaultName,
        scheduleExpression.map(value => value),
        startWindowMinutes.map(value => value),
        completionWindowMinutes.map(value => value),
        lifecycle.map(value => value.asEditable),
        recoveryPointTags.map(value => value),
        ruleId.map(value => value),
        copyActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableContinuousBackup.map(value => value)
      )
    def ruleName: BackupRuleName
    def targetBackupVaultName: BackupVaultName
    def scheduleExpression: Option[CronExpression]
    def startWindowMinutes: Option[WindowMinutes]
    def completionWindowMinutes: Option[WindowMinutes]
    def lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly]
    def recoveryPointTags: Option[Map[TagKey, TagValue]]
    def ruleId: Option[String]
    def copyActions: Option[List[zio.aws.backup.model.CopyAction.ReadOnly]]
    def enableContinuousBackup: Option[Boolean]
    def getRuleName: ZIO[Any, Nothing, BackupRuleName] = ZIO.succeed(ruleName)
    def getTargetBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(targetBackupVaultName)
    def getScheduleExpression: ZIO[Any, AwsError, CronExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getStartWindowMinutes: ZIO[Any, AwsError, WindowMinutes] =
      AwsError.unwrapOptionField("startWindowMinutes", startWindowMinutes)
    def getCompletionWindowMinutes: ZIO[Any, AwsError, WindowMinutes] = AwsError
      .unwrapOptionField("completionWindowMinutes", completionWindowMinutes)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getRecoveryPointTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("recoveryPointTags", recoveryPointTags)
    def getRuleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getCopyActions
        : ZIO[Any, AwsError, List[zio.aws.backup.model.CopyAction.ReadOnly]] =
      AwsError.unwrapOptionField("copyActions", copyActions)
    def getEnableContinuousBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableContinuousBackup", enableContinuousBackup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupRule
  ) extends zio.aws.backup.model.BackupRule.ReadOnly {
    override val ruleName: BackupRuleName =
      zio.aws.backup.model.primitives.BackupRuleName(impl.ruleName())
    override val targetBackupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives
        .BackupVaultName(impl.targetBackupVaultName())
    override val scheduleExpression: Option[CronExpression] = scala
      .Option(impl.scheduleExpression())
      .map(value => zio.aws.backup.model.primitives.CronExpression(value))
    override val startWindowMinutes: Option[WindowMinutes] = scala
      .Option(impl.startWindowMinutes())
      .map(value => zio.aws.backup.model.primitives.WindowMinutes(value))
    override val completionWindowMinutes: Option[WindowMinutes] = scala
      .Option(impl.completionWindowMinutes())
      .map(value => zio.aws.backup.model.primitives.WindowMinutes(value))
    override val lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
    override val recoveryPointTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.recoveryPointTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.backup.model.primitives
              .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val ruleId: Option[String] =
      scala.Option(impl.ruleId()).map(value => value: String)
    override val copyActions
        : Option[List[zio.aws.backup.model.CopyAction.ReadOnly]] = scala
      .Option(impl.copyActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.CopyAction.wrap(item)
        }.toList
      )
    override val enableContinuousBackup: Option[Boolean] =
      scala.Option(impl.enableContinuousBackup()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupRule
  ): zio.aws.backup.model.BackupRule.ReadOnly = new Wrapper(impl)
}
