package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait BackupVaultEvent {
  def unwrap: software.amazon.awssdk.services.backup.model.BackupVaultEvent
}
object BackupVaultEvent {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.BackupVaultEvent
  ): zio.aws.backup.model.BackupVaultEvent = value match {
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_STARTED =>
      val r = BACKUP_JOB_STARTED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_COMPLETED =>
      val r = BACKUP_JOB_COMPLETED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_SUCCESSFUL =>
      val r = BACKUP_JOB_SUCCESSFUL
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_FAILED =>
      val r = BACKUP_JOB_FAILED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_EXPIRED =>
      val r = BACKUP_JOB_EXPIRED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_STARTED =>
      val r = RESTORE_JOB_STARTED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_COMPLETED =>
      val r = RESTORE_JOB_COMPLETED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_SUCCESSFUL =>
      val r = RESTORE_JOB_SUCCESSFUL
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_FAILED =>
      val r = RESTORE_JOB_FAILED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.COPY_JOB_STARTED =>
      val r = COPY_JOB_STARTED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.COPY_JOB_SUCCESSFUL =>
      val r = COPY_JOB_SUCCESSFUL
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.COPY_JOB_FAILED =>
      val r = COPY_JOB_FAILED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.RECOVERY_POINT_MODIFIED =>
      val r = RECOVERY_POINT_MODIFIED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_PLAN_CREATED =>
      val r = BACKUP_PLAN_CREATED
      r
    case software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_PLAN_MODIFIED =>
      val r = BACKUP_PLAN_MODIFIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object BACKUP_JOB_STARTED extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_STARTED
  }
  case object BACKUP_JOB_COMPLETED
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_COMPLETED
  }
  case object BACKUP_JOB_SUCCESSFUL
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_SUCCESSFUL
  }
  case object BACKUP_JOB_FAILED extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_FAILED
  }
  case object BACKUP_JOB_EXPIRED extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_JOB_EXPIRED
  }
  case object RESTORE_JOB_STARTED
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_STARTED
  }
  case object RESTORE_JOB_COMPLETED
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_COMPLETED
  }
  case object RESTORE_JOB_SUCCESSFUL
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_SUCCESSFUL
  }
  case object RESTORE_JOB_FAILED extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.RESTORE_JOB_FAILED
  }
  case object COPY_JOB_STARTED extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.COPY_JOB_STARTED
  }
  case object COPY_JOB_SUCCESSFUL
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.COPY_JOB_SUCCESSFUL
  }
  case object COPY_JOB_FAILED extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.COPY_JOB_FAILED
  }
  case object RECOVERY_POINT_MODIFIED
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.RECOVERY_POINT_MODIFIED
  }
  case object BACKUP_PLAN_CREATED
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_PLAN_CREATED
  }
  case object BACKUP_PLAN_MODIFIED
      extends zio.aws.backup.model.BackupVaultEvent {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.BackupVaultEvent =
      software.amazon.awssdk.services.backup.model.BackupVaultEvent.BACKUP_PLAN_MODIFIED
  }
}
