package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CalculatedLifecycle(
    moveToColdStorageAt: Option[Timestamp] = None,
    deleteAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CalculatedLifecycle = {
    import CalculatedLifecycle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CalculatedLifecycle
      .builder()
      .optionallyWith(
        moveToColdStorageAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.moveToColdStorageAt)
      .optionallyWith(deleteAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deleteAt
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CalculatedLifecycle.ReadOnly =
    zio.aws.backup.model.CalculatedLifecycle.wrap(buildAwsValue())
}
object CalculatedLifecycle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CalculatedLifecycle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CalculatedLifecycle =
      zio.aws.backup.model.CalculatedLifecycle(
        moveToColdStorageAt.map(value => value),
        deleteAt.map(value => value)
      )
    def moveToColdStorageAt: Option[Timestamp]
    def deleteAt: Option[Timestamp]
    def getMoveToColdStorageAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("moveToColdStorageAt", moveToColdStorageAt)
    def getDeleteAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deleteAt", deleteAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CalculatedLifecycle
  ) extends zio.aws.backup.model.CalculatedLifecycle.ReadOnly {
    override val moveToColdStorageAt: Option[Timestamp] = scala
      .Option(impl.moveToColdStorageAt())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deleteAt: Option[Timestamp] = scala
      .Option(impl.deleteAt())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CalculatedLifecycle
  ): zio.aws.backup.model.CalculatedLifecycle.ReadOnly = new Wrapper(impl)
}
