package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.{ConditionValue, ConditionKey}
import scala.jdk.CollectionConverters._
final case class Condition(
    conditionType: zio.aws.backup.model.ConditionType,
    conditionKey: ConditionKey,
    conditionValue: ConditionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.Condition
      .builder()
      .conditionType(conditionType.unwrap)
      .conditionKey(ConditionKey.unwrap(conditionKey): java.lang.String)
      .conditionValue(ConditionValue.unwrap(conditionValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.Condition.ReadOnly =
    zio.aws.backup.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.Condition] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.Condition = zio.aws.backup.model
      .Condition(conditionType, conditionKey, conditionValue)
    def conditionType: zio.aws.backup.model.ConditionType
    def conditionKey: ConditionKey
    def conditionValue: ConditionValue
    def getConditionType
        : ZIO[Any, Nothing, zio.aws.backup.model.ConditionType] =
      ZIO.succeed(conditionType)
    def getConditionKey: ZIO[Any, Nothing, ConditionKey] =
      ZIO.succeed(conditionKey)
    def getConditionValue: ZIO[Any, Nothing, ConditionValue] =
      ZIO.succeed(conditionValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.Condition
  ) extends zio.aws.backup.model.Condition.ReadOnly {
    override val conditionType: zio.aws.backup.model.ConditionType =
      zio.aws.backup.model.ConditionType.wrap(impl.conditionType())
    override val conditionKey: ConditionKey =
      zio.aws.backup.model.primitives.ConditionKey(impl.conditionKey())
    override val conditionValue: ConditionValue =
      zio.aws.backup.model.primitives.ConditionValue(impl.conditionValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.Condition
  ): zio.aws.backup.model.Condition.ReadOnly = new Wrapper(impl)
}
