package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ConditionValue, ConditionKey}
import scala.jdk.CollectionConverters._
final case class ConditionParameter(
    conditionKey: Option[ConditionKey] = None,
    conditionValue: Option[ConditionValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ConditionParameter = {
    import ConditionParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ConditionParameter
      .builder()
      .optionallyWith(
        conditionKey.map(value => ConditionKey.unwrap(value): java.lang.String)
      )(_.conditionKey)
      .optionallyWith(
        conditionValue.map(value =>
          ConditionValue.unwrap(value): java.lang.String
        )
      )(_.conditionValue)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ConditionParameter.ReadOnly =
    zio.aws.backup.model.ConditionParameter.wrap(buildAwsValue())
}
object ConditionParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ConditionParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ConditionParameter =
      zio.aws.backup.model.ConditionParameter(
        conditionKey.map(value => value),
        conditionValue.map(value => value)
      )
    def conditionKey: Option[ConditionKey]
    def conditionValue: Option[ConditionValue]
    def getConditionKey: ZIO[Any, AwsError, ConditionKey] =
      AwsError.unwrapOptionField("conditionKey", conditionKey)
    def getConditionValue: ZIO[Any, AwsError, ConditionValue] =
      AwsError.unwrapOptionField("conditionValue", conditionValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ConditionParameter
  ) extends zio.aws.backup.model.ConditionParameter.ReadOnly {
    override val conditionKey: Option[ConditionKey] = scala
      .Option(impl.conditionKey())
      .map(value => zio.aws.backup.model.primitives.ConditionKey(value))
    override val conditionValue: Option[ConditionValue] = scala
      .Option(impl.conditionValue())
      .map(value => zio.aws.backup.model.primitives.ConditionValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ConditionParameter
  ): zio.aws.backup.model.ConditionParameter.ReadOnly = new Wrapper(impl)
}
