package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class ControlScope(
    complianceResourceIds: Option[Iterable[String]] = None,
    complianceResourceTypes: Option[Iterable[ARN]] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ControlScope = {
    import ControlScope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ControlScope
      .builder()
      .optionallyWith(
        complianceResourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.complianceResourceIds)
      .optionallyWith(
        complianceResourceTypes.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.complianceResourceTypes)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ControlScope.ReadOnly =
    zio.aws.backup.model.ControlScope.wrap(buildAwsValue())
}
object ControlScope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ControlScope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ControlScope =
      zio.aws.backup.model.ControlScope(
        complianceResourceIds.map(value => value),
        complianceResourceTypes.map(value => value),
        tags.map(value => value)
      )
    def complianceResourceIds: Option[List[String]]
    def complianceResourceTypes: Option[List[ARN]]
    def tags: Option[Map[String, String]]
    def getComplianceResourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("complianceResourceIds", complianceResourceIds)
    def getComplianceResourceTypes: ZIO[Any, AwsError, List[ARN]] = AwsError
      .unwrapOptionField("complianceResourceTypes", complianceResourceTypes)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ControlScope
  ) extends zio.aws.backup.model.ControlScope.ReadOnly {
    override val complianceResourceIds: Option[List[String]] = scala
      .Option(impl.complianceResourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val complianceResourceTypes: Option[List[ARN]] = scala
      .Option(impl.complianceResourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.primitives.ARN(item)
        }.toList
      )
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ControlScope
  ): zio.aws.backup.model.ControlScope.ReadOnly = new Wrapper(impl)
}
