package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateBackupPlanResponse(
    backupPlanId: Option[String] = None,
    backupPlanArn: Option[ARN] = None,
    creationDate: Option[Timestamp] = None,
    versionId: Option[String] = None,
    advancedBackupSettings: Option[
      Iterable[zio.aws.backup.model.AdvancedBackupSetting]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse = {
    import CreateBackupPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse
      .builder()
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        backupPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupPlanArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.advancedBackupSettings)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly =
    zio.aws.backup.model.CreateBackupPlanResponse.wrap(buildAwsValue())
}
object CreateBackupPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateBackupPlanResponse =
      zio.aws.backup.model.CreateBackupPlanResponse(
        backupPlanId.map(value => value),
        backupPlanArn.map(value => value),
        creationDate.map(value => value),
        versionId.map(value => value),
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupPlanId: Option[String]
    def backupPlanArn: Option[ARN]
    def creationDate: Option[Timestamp]
    def versionId: Option[String]
    def advancedBackupSettings
        : Option[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]]
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getBackupPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getVersionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getAdvancedBackupSettings: ZIO[Any, AwsError, List[
      zio.aws.backup.model.AdvancedBackupSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "advancedBackupSettings",
      advancedBackupSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse
  ) extends zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly {
    override val backupPlanId: Option[String] =
      scala.Option(impl.backupPlanId()).map(value => value: String)
    override val backupPlanArn: Option[ARN] = scala
      .Option(impl.backupPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val versionId: Option[String] =
      scala.Option(impl.versionId()).map(value => value: String)
    override val advancedBackupSettings
        : Option[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]] =
      scala
        .Option(impl.advancedBackupSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.AdvancedBackupSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse
  ): zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly = new Wrapper(impl)
}
