package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ARN, FrameworkName}
import scala.jdk.CollectionConverters._
final case class CreateFrameworkResponse(
    frameworkName: Option[FrameworkName] = None,
    frameworkArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateFrameworkResponse = {
    import CreateFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateFrameworkResponse
      .builder()
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.frameworkArn)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateFrameworkResponse.ReadOnly =
    zio.aws.backup.model.CreateFrameworkResponse.wrap(buildAwsValue())
}
object CreateFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateFrameworkResponse =
      zio.aws.backup.model.CreateFrameworkResponse(
        frameworkName.map(value => value),
        frameworkArn.map(value => value)
      )
    def frameworkName: Option[FrameworkName]
    def frameworkArn: Option[ARN]
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("frameworkArn", frameworkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateFrameworkResponse
  ) extends zio.aws.backup.model.CreateFrameworkResponse.ReadOnly {
    override val frameworkName: Option[FrameworkName] = scala
      .Option(impl.frameworkName())
      .map(value => zio.aws.backup.model.primitives.FrameworkName(value))
    override val frameworkArn: Option[ARN] = scala
      .Option(impl.frameworkArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateFrameworkResponse
  ): zio.aws.backup.model.CreateFrameworkResponse.ReadOnly = new Wrapper(impl)
}
