package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBackupPlanRequest(backupPlanId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest = {
    import DeleteBackupPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteBackupPlanRequest.ReadOnly =
    zio.aws.backup.model.DeleteBackupPlanRequest.wrap(buildAwsValue())
}
object DeleteBackupPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteBackupPlanRequest =
      zio.aws.backup.model.DeleteBackupPlanRequest(backupPlanId)
    def backupPlanId: String
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest
  ) extends zio.aws.backup.model.DeleteBackupPlanRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest
  ): zio.aws.backup.model.DeleteBackupPlanRequest.ReadOnly = new Wrapper(impl)
}
