package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBackupSelectionRequest(
    backupPlanId: String,
    selectionId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest = {
    import DeleteBackupSelectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .selectionId(selectionId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteBackupSelectionRequest.ReadOnly =
    zio.aws.backup.model.DeleteBackupSelectionRequest.wrap(buildAwsValue())
}
object DeleteBackupSelectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteBackupSelectionRequest =
      zio.aws.backup.model
        .DeleteBackupSelectionRequest(backupPlanId, selectionId)
    def backupPlanId: String
    def selectionId: String
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
    def getSelectionId: ZIO[Any, Nothing, String] = ZIO.succeed(selectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest
  ) extends zio.aws.backup.model.DeleteBackupSelectionRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
    override val selectionId: String = impl.selectionId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest
  ): zio.aws.backup.model.DeleteBackupSelectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
