package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  AccountId,
  Timestamp,
  BackupVaultName,
  ResourceType,
  BackupOptionKey,
  BackupOptionValue,
  ARN
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeBackupJobResponse(
    accountId: Option[AccountId] = None,
    backupJobId: Option[String] = None,
    backupVaultName: Option[BackupVaultName] = None,
    backupVaultArn: Option[ARN] = None,
    recoveryPointArn: Option[ARN] = None,
    resourceArn: Option[ARN] = None,
    creationDate: Option[Timestamp] = None,
    completionDate: Option[Timestamp] = None,
    state: Option[zio.aws.backup.model.BackupJobState] = None,
    statusMessage: Option[String] = None,
    percentDone: Option[String] = None,
    backupSizeInBytes: Option[Long] = None,
    iamRoleArn: Option[IAMRoleArn] = None,
    createdBy: Option[zio.aws.backup.model.RecoveryPointCreator] = None,
    resourceType: Option[ResourceType] = None,
    bytesTransferred: Option[Long] = None,
    expectedCompletionDate: Option[Timestamp] = None,
    startBy: Option[Timestamp] = None,
    backupOptions: Option[Map[BackupOptionKey, BackupOptionValue]] = None,
    backupType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse = {
    import DescribeBackupJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(backupJobId.map(value => value: java.lang.String))(
        _.backupJobId
      )
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(percentDone.map(value => value: java.lang.String))(
        _.percentDone
      )
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(bytesTransferred.map(value => value: java.lang.Long))(
        _.bytesTransferred
      )
      .optionallyWith(
        expectedCompletionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expectedCompletionDate)
      .optionallyWith(startBy.map(value => Timestamp.unwrap(value): Instant))(
        _.startBy
      )
      .optionallyWith(
        backupOptions.map(value =>
          value
            .map({ case (key, value) =>
              (BackupOptionKey
                .unwrap(key): java.lang.String) -> (BackupOptionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.backupOptions)
      .optionallyWith(backupType.map(value => value: java.lang.String))(
        _.backupType
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly =
    zio.aws.backup.model.DescribeBackupJobResponse.wrap(buildAwsValue())
}
object DescribeBackupJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeBackupJobResponse =
      zio.aws.backup.model.DescribeBackupJobResponse(
        accountId.map(value => value),
        backupJobId.map(value => value),
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        recoveryPointArn.map(value => value),
        resourceArn.map(value => value),
        creationDate.map(value => value),
        completionDate.map(value => value),
        state.map(value => value),
        statusMessage.map(value => value),
        percentDone.map(value => value),
        backupSizeInBytes.map(value => value),
        iamRoleArn.map(value => value),
        createdBy.map(value => value.asEditable),
        resourceType.map(value => value),
        bytesTransferred.map(value => value),
        expectedCompletionDate.map(value => value),
        startBy.map(value => value),
        backupOptions.map(value => value),
        backupType.map(value => value)
      )
    def accountId: Option[AccountId]
    def backupJobId: Option[String]
    def backupVaultName: Option[BackupVaultName]
    def backupVaultArn: Option[ARN]
    def recoveryPointArn: Option[ARN]
    def resourceArn: Option[ARN]
    def creationDate: Option[Timestamp]
    def completionDate: Option[Timestamp]
    def state: Option[zio.aws.backup.model.BackupJobState]
    def statusMessage: Option[String]
    def percentDone: Option[String]
    def backupSizeInBytes: Option[Long]
    def iamRoleArn: Option[IAMRoleArn]
    def createdBy: Option[zio.aws.backup.model.RecoveryPointCreator.ReadOnly]
    def resourceType: Option[ResourceType]
    def bytesTransferred: Option[Long]
    def expectedCompletionDate: Option[Timestamp]
    def startBy: Option[Timestamp]
    def backupOptions: Option[Map[BackupOptionKey, BackupOptionValue]]
    def backupType: Option[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getBackupJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupJobId", backupJobId)
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getState: ZIO[Any, AwsError, zio.aws.backup.model.BackupJobState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getPercentDone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentDone", percentDone)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointCreator.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getBytesTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesTransferred", bytesTransferred)
    def getExpectedCompletionDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("expectedCompletionDate", expectedCompletionDate)
    def getStartBy: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startBy", startBy)
    def getBackupOptions
        : ZIO[Any, AwsError, Map[BackupOptionKey, BackupOptionValue]] =
      AwsError.unwrapOptionField("backupOptions", backupOptions)
    def getBackupType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupType", backupType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
  ) extends zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val backupJobId: Option[String] =
      scala.Option(impl.backupJobId()).map(value => value: String)
    override val backupVaultName: Option[BackupVaultName] = scala
      .Option(impl.backupVaultName())
      .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Option[ARN] = scala
      .Option(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val recoveryPointArn: Option[ARN] = scala
      .Option(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceArn: Option[ARN] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Option[Timestamp] = scala
      .Option(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val state: Option[zio.aws.backup.model.BackupJobState] = scala
      .Option(impl.state())
      .map(value => zio.aws.backup.model.BackupJobState.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val percentDone: Option[String] =
      scala.Option(impl.percentDone()).map(value => value: String)
    override val backupSizeInBytes: Option[Long] =
      scala.Option(impl.backupSizeInBytes()).map(value => value: Long)
    override val iamRoleArn: Option[IAMRoleArn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val createdBy
        : Option[zio.aws.backup.model.RecoveryPointCreator.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.backup.model.RecoveryPointCreator.wrap(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val bytesTransferred: Option[Long] =
      scala.Option(impl.bytesTransferred()).map(value => value: Long)
    override val expectedCompletionDate: Option[Timestamp] = scala
      .Option(impl.expectedCompletionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val startBy: Option[Timestamp] = scala
      .Option(impl.startBy())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val backupOptions
        : Option[Map[BackupOptionKey, BackupOptionValue]] = scala
      .Option(impl.backupOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.backup.model.primitives.BackupOptionKey(
              key
            ) -> zio.aws.backup.model.primitives.BackupOptionValue(value)
          })
          .toMap
      )
    override val backupType: Option[String] =
      scala.Option(impl.backupType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
  ): zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly = new Wrapper(impl)
}
