package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeBackupVaultRequest(backupVaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest = {
    import DescribeBackupVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest
      .builder()
      .backupVaultName(backupVaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeBackupVaultRequest.ReadOnly =
    zio.aws.backup.model.DescribeBackupVaultRequest.wrap(buildAwsValue())
}
object DescribeBackupVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeBackupVaultRequest =
      zio.aws.backup.model.DescribeBackupVaultRequest(backupVaultName)
    def backupVaultName: String
    def getBackupVaultName: ZIO[Any, Nothing, String] =
      ZIO.succeed(backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest
  ) extends zio.aws.backup.model.DescribeBackupVaultRequest.ReadOnly {
    override val backupVaultName: String = impl.backupVaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest
  ): zio.aws.backup.model.DescribeBackupVaultRequest.ReadOnly = new Wrapper(
    impl
  )
}
