package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCopyJobResponse(
    copyJob: Option[zio.aws.backup.model.CopyJob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse = {
    import DescribeCopyJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse
      .builder()
      .optionallyWith(copyJob.map(value => value.buildAwsValue()))(_.copyJob)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly =
    zio.aws.backup.model.DescribeCopyJobResponse.wrap(buildAwsValue())
}
object DescribeCopyJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeCopyJobResponse =
      zio.aws.backup.model
        .DescribeCopyJobResponse(copyJob.map(value => value.asEditable))
    def copyJob: Option[zio.aws.backup.model.CopyJob.ReadOnly]
    def getCopyJob: ZIO[Any, AwsError, zio.aws.backup.model.CopyJob.ReadOnly] =
      AwsError.unwrapOptionField("copyJob", copyJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse
  ) extends zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly {
    override val copyJob: Option[zio.aws.backup.model.CopyJob.ReadOnly] = scala
      .Option(impl.copyJob())
      .map(value => zio.aws.backup.model.CopyJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse
  ): zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly = new Wrapper(impl)
}
