package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  Timestamp,
  FrameworkDescription,
  ARN,
  FrameworkName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeFrameworkResponse(
    frameworkName: Option[FrameworkName] = None,
    frameworkArn: Option[ARN] = None,
    frameworkDescription: Option[FrameworkDescription] = None,
    frameworkControls: Option[Iterable[zio.aws.backup.model.FrameworkControl]] =
      None,
    creationTime: Option[Timestamp] = None,
    deploymentStatus: Option[String] = None,
    frameworkStatus: Option[String] = None,
    idempotencyToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse = {
    import DescribeFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
      .builder()
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.frameworkArn)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .optionallyWith(
        frameworkControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameworkControls)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(deploymentStatus.map(value => value: java.lang.String))(
        _.deploymentStatus
      )
      .optionallyWith(frameworkStatus.map(value => value: java.lang.String))(
        _.frameworkStatus
      )
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly =
    zio.aws.backup.model.DescribeFrameworkResponse.wrap(buildAwsValue())
}
object DescribeFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeFrameworkResponse =
      zio.aws.backup.model.DescribeFrameworkResponse(
        frameworkName.map(value => value),
        frameworkArn.map(value => value),
        frameworkDescription.map(value => value),
        frameworkControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        deploymentStatus.map(value => value),
        frameworkStatus.map(value => value),
        idempotencyToken.map(value => value)
      )
    def frameworkName: Option[FrameworkName]
    def frameworkArn: Option[ARN]
    def frameworkDescription: Option[FrameworkDescription]
    def frameworkControls
        : Option[List[zio.aws.backup.model.FrameworkControl.ReadOnly]]
    def creationTime: Option[Timestamp]
    def deploymentStatus: Option[String]
    def frameworkStatus: Option[String]
    def idempotencyToken: Option[String]
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("frameworkArn", frameworkArn)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getFrameworkControls: ZIO[Any, AwsError, List[
      zio.aws.backup.model.FrameworkControl.ReadOnly
    ]] = AwsError.unwrapOptionField("frameworkControls", frameworkControls)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeploymentStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getFrameworkStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frameworkStatus", frameworkStatus)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
  ) extends zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly {
    override val frameworkName: Option[FrameworkName] = scala
      .Option(impl.frameworkName())
      .map(value => zio.aws.backup.model.primitives.FrameworkName(value))
    override val frameworkArn: Option[ARN] = scala
      .Option(impl.frameworkArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val frameworkDescription: Option[FrameworkDescription] = scala
      .Option(impl.frameworkDescription())
      .map(value => zio.aws.backup.model.primitives.FrameworkDescription(value))
    override val frameworkControls
        : Option[List[zio.aws.backup.model.FrameworkControl.ReadOnly]] = scala
      .Option(impl.frameworkControls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.FrameworkControl.wrap(item)
        }.toList
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deploymentStatus: Option[String] =
      scala.Option(impl.deploymentStatus()).map(value => value: String)
    override val frameworkStatus: Option[String] =
      scala.Option(impl.frameworkStatus()).map(value => value: String)
    override val idempotencyToken: Option[String] =
      scala.Option(impl.idempotencyToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
  ): zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly = new Wrapper(impl)
}
