package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{IsEnabled, ResourceType}
import scala.jdk.CollectionConverters._
final case class DescribeRegionSettingsResponse(
    resourceTypeOptInPreference: Option[Map[ResourceType, IsEnabled]] = None,
    resourceTypeManagementPreference: Option[Map[ResourceType, IsEnabled]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse = {
    import DescribeRegionSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse
      .builder()
      .optionallyWith(
        resourceTypeOptInPreference.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceType.unwrap(key): java.lang.String) -> (IsEnabled
                .unwrap(value): java.lang.Boolean)
            })
            .asJava
        )
      )(_.resourceTypeOptInPreference)
      .optionallyWith(
        resourceTypeManagementPreference.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceType.unwrap(key): java.lang.String) -> (IsEnabled
                .unwrap(value): java.lang.Boolean)
            })
            .asJava
        )
      )(_.resourceTypeManagementPreference)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly =
    zio.aws.backup.model.DescribeRegionSettingsResponse.wrap(buildAwsValue())
}
object DescribeRegionSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeRegionSettingsResponse =
      zio.aws.backup.model.DescribeRegionSettingsResponse(
        resourceTypeOptInPreference.map(value => value),
        resourceTypeManagementPreference.map(value => value)
      )
    def resourceTypeOptInPreference: Option[Map[ResourceType, IsEnabled]]
    def resourceTypeManagementPreference: Option[Map[ResourceType, IsEnabled]]
    def getResourceTypeOptInPreference
        : ZIO[Any, AwsError, Map[ResourceType, IsEnabled]] =
      AwsError.unwrapOptionField(
        "resourceTypeOptInPreference",
        resourceTypeOptInPreference
      )
    def getResourceTypeManagementPreference
        : ZIO[Any, AwsError, Map[ResourceType, IsEnabled]] =
      AwsError.unwrapOptionField(
        "resourceTypeManagementPreference",
        resourceTypeManagementPreference
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse
  ) extends zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly {
    override val resourceTypeOptInPreference
        : Option[Map[ResourceType, IsEnabled]] = scala
      .Option(impl.resourceTypeOptInPreference())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.backup.model.primitives.ResourceType(
              key
            ) -> zio.aws.backup.model.primitives.IsEnabled(value)
          })
          .toMap
      )
    override val resourceTypeManagementPreference
        : Option[Map[ResourceType, IsEnabled]] = scala
      .Option(impl.resourceTypeManagementPreference())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.backup.model.primitives.ResourceType(
              key
            ) -> zio.aws.backup.model.primitives.IsEnabled(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse
  ): zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
