package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.ReportPlanName
import scala.jdk.CollectionConverters._
final case class DescribeReportPlanRequest(reportPlanName: ReportPlanName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest = {
    import DescribeReportPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest
      .builder()
      .reportPlanName(ReportPlanName.unwrap(reportPlanName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeReportPlanRequest.ReadOnly =
    zio.aws.backup.model.DescribeReportPlanRequest.wrap(buildAwsValue())
}
object DescribeReportPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeReportPlanRequest =
      zio.aws.backup.model.DescribeReportPlanRequest(reportPlanName)
    def reportPlanName: ReportPlanName
    def getReportPlanName: ZIO[Any, Nothing, ReportPlanName] =
      ZIO.succeed(reportPlanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest
  ) extends zio.aws.backup.model.DescribeReportPlanRequest.ReadOnly {
    override val reportPlanName: ReportPlanName =
      zio.aws.backup.model.primitives.ReportPlanName(impl.reportPlanName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest
  ): zio.aws.backup.model.DescribeReportPlanRequest.ReadOnly = new Wrapper(impl)
}
