package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportBackupPlanTemplateRequest(backupPlanId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest = {
    import ExportBackupPlanTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ExportBackupPlanTemplateRequest.ReadOnly =
    zio.aws.backup.model.ExportBackupPlanTemplateRequest.wrap(buildAwsValue())
}
object ExportBackupPlanTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ExportBackupPlanTemplateRequest =
      zio.aws.backup.model.ExportBackupPlanTemplateRequest(backupPlanId)
    def backupPlanId: String
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest
  ) extends zio.aws.backup.model.ExportBackupPlanTemplateRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest
  ): zio.aws.backup.model.ExportBackupPlanTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
