package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.BackupVaultName
import scala.jdk.CollectionConverters._
final case class GetBackupVaultNotificationsRequest(
    backupVaultName: BackupVaultName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest = {
    import GetBackupVaultNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetBackupVaultNotificationsRequest.ReadOnly =
    zio.aws.backup.model.GetBackupVaultNotificationsRequest
      .wrap(buildAwsValue())
}
object GetBackupVaultNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupVaultNotificationsRequest =
      zio.aws.backup.model.GetBackupVaultNotificationsRequest(backupVaultName)
    def backupVaultName: BackupVaultName
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest
  ) extends zio.aws.backup.model.GetBackupVaultNotificationsRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest
  ): zio.aws.backup.model.GetBackupVaultNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
