package zio.aws.backup.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.MaxResults
import scala.jdk.CollectionConverters._
final case class ListBackupPlanVersionsRequest(
    backupPlanId: String,
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest = {
    import ListBackupPlanVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupPlanVersionsRequest.ReadOnly =
    zio.aws.backup.model.ListBackupPlanVersionsRequest.wrap(buildAwsValue())
}
object ListBackupPlanVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupPlanVersionsRequest =
      zio.aws.backup.model.ListBackupPlanVersionsRequest(
        backupPlanId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def backupPlanId: String
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest
  ) extends zio.aws.backup.model.ListBackupPlanVersionsRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest
  ): zio.aws.backup.model.ListBackupPlanVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
