package zio.aws.backup.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.MaxResults
import scala.jdk.CollectionConverters._
final case class ListBackupPlansRequest(
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None,
    includeDeleted: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupPlansRequest = {
    import ListBackupPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupPlansRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(includeDeleted.map(value => value: java.lang.Boolean))(
        _.includeDeleted
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupPlansRequest.ReadOnly =
    zio.aws.backup.model.ListBackupPlansRequest.wrap(buildAwsValue())
}
object ListBackupPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupPlansRequest =
      zio.aws.backup.model.ListBackupPlansRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        includeDeleted.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def includeDeleted: Option[Boolean]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIncludeDeleted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDeleted", includeDeleted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlansRequest
  ) extends zio.aws.backup.model.ListBackupPlansRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val includeDeleted: Option[Boolean] =
      scala.Option(impl.includeDeleted()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlansRequest
  ): zio.aws.backup.model.ListBackupPlansRequest.ReadOnly = new Wrapper(impl)
}
