package zio.aws.backup.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.MaxResults
import scala.jdk.CollectionConverters._
final case class ListBackupVaultsRequest(
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest = {
    import ListBackupVaultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupVaultsRequest.ReadOnly =
    zio.aws.backup.model.ListBackupVaultsRequest.wrap(buildAwsValue())
}
object ListBackupVaultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupVaultsRequest =
      zio.aws.backup.model.ListBackupVaultsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
  ) extends zio.aws.backup.model.ListBackupVaultsRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
  ): zio.aws.backup.model.ListBackupVaultsRequest.ReadOnly = new Wrapper(impl)
}
