package zio.aws.backup.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{MaxResults, ARN}
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsByResourceRequest(
    resourceArn: ARN,
    nextToken: Option[String] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest = {
    import ListRecoveryPointsByResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListRecoveryPointsByResourceRequest.ReadOnly =
    zio.aws.backup.model.ListRecoveryPointsByResourceRequest
      .wrap(buildAwsValue())
}
object ListRecoveryPointsByResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListRecoveryPointsByResourceRequest =
      zio.aws.backup.model.ListRecoveryPointsByResourceRequest(
        resourceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: ARN
    def nextToken: Option[String]
    def maxResults: Option[MaxResults]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest
  ) extends zio.aws.backup.model.ListRecoveryPointsByResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.resourceArn())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest
  ): zio.aws.backup.model.ListRecoveryPointsByResourceRequest.ReadOnly =
    new Wrapper(impl)
}
