package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.{ARN, BackupVaultName}
import scala.jdk.CollectionConverters._
final case class PutBackupVaultNotificationsRequest(
    backupVaultName: BackupVaultName,
    snsTopicArn: ARN,
    backupVaultEvents: Iterable[zio.aws.backup.model.BackupVaultEvent]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest = {
    import PutBackupVaultNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .snsTopicArn(ARN.unwrap(snsTopicArn): java.lang.String)
      .backupVaultEventsWithStrings(backupVaultEvents.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.PutBackupVaultNotificationsRequest.ReadOnly =
    zio.aws.backup.model.PutBackupVaultNotificationsRequest
      .wrap(buildAwsValue())
}
object PutBackupVaultNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.PutBackupVaultNotificationsRequest =
      zio.aws.backup.model.PutBackupVaultNotificationsRequest(
        backupVaultName,
        snsTopicArn,
        backupVaultEvents
      )
    def backupVaultName: BackupVaultName
    def snsTopicArn: ARN
    def backupVaultEvents: List[zio.aws.backup.model.BackupVaultEvent]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getSnsTopicArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(snsTopicArn)
    def getBackupVaultEvents
        : ZIO[Any, Nothing, List[zio.aws.backup.model.BackupVaultEvent]] =
      ZIO.succeed(backupVaultEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest
  ) extends zio.aws.backup.model.PutBackupVaultNotificationsRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val snsTopicArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.snsTopicArn())
    override val backupVaultEvents
        : List[zio.aws.backup.model.BackupVaultEvent] = impl
      .backupVaultEvents()
      .asScala
      .map { item =>
        zio.aws.backup.model.BackupVaultEvent.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest
  ): zio.aws.backup.model.PutBackupVaultNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
