package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StartCopyJobResponse(
    copyJobId: Option[String] = None,
    creationDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartCopyJobResponse = {
    import StartCopyJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartCopyJobResponse
      .builder()
      .optionallyWith(copyJobId.map(value => value: java.lang.String))(
        _.copyJobId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartCopyJobResponse.ReadOnly =
    zio.aws.backup.model.StartCopyJobResponse.wrap(buildAwsValue())
}
object StartCopyJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartCopyJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartCopyJobResponse =
      zio.aws.backup.model.StartCopyJobResponse(
        copyJobId.map(value => value),
        creationDate.map(value => value)
      )
    def copyJobId: Option[String]
    def creationDate: Option[Timestamp]
    def getCopyJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("copyJobId", copyJobId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartCopyJobResponse
  ) extends zio.aws.backup.model.StartCopyJobResponse.ReadOnly {
    override val copyJobId: Option[String] =
      scala.Option(impl.copyJobId()).map(value => value: String)
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartCopyJobResponse
  ): zio.aws.backup.model.StartCopyJobResponse.ReadOnly = new Wrapper(impl)
}
