package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateBackupPlanRequest(
    backupPlanId: String,
    backupPlan: zio.aws.backup.model.BackupPlanInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest = {
    import UpdateBackupPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .backupPlan(backupPlan.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UpdateBackupPlanRequest.ReadOnly =
    zio.aws.backup.model.UpdateBackupPlanRequest.wrap(buildAwsValue())
}
object UpdateBackupPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateBackupPlanRequest =
      zio.aws.backup.model
        .UpdateBackupPlanRequest(backupPlanId, backupPlan.asEditable)
    def backupPlanId: String
    def backupPlan: zio.aws.backup.model.BackupPlanInput.ReadOnly
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
    def getBackupPlan
        : ZIO[Any, Nothing, zio.aws.backup.model.BackupPlanInput.ReadOnly] =
      ZIO.succeed(backupPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest
  ) extends zio.aws.backup.model.UpdateBackupPlanRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
    override val backupPlan: zio.aws.backup.model.BackupPlanInput.ReadOnly =
      zio.aws.backup.model.BackupPlanInput.wrap(impl.backupPlan())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest
  ): zio.aws.backup.model.UpdateBackupPlanRequest.ReadOnly = new Wrapper(impl)
}
