package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class UpdateRecoveryPointLifecycleResponse(
    backupVaultArn: Option[ARN] = None,
    recoveryPointArn: Option[ARN] = None,
    lifecycle: Option[zio.aws.backup.model.Lifecycle] = None,
    calculatedLifecycle: Option[zio.aws.backup.model.CalculatedLifecycle] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse = {
    import UpdateRecoveryPointLifecycleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse
      .builder()
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(calculatedLifecycle.map(value => value.buildAwsValue()))(
        _.calculatedLifecycle
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly =
    zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse
      .wrap(buildAwsValue())
}
object UpdateRecoveryPointLifecycleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse =
      zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse(
        backupVaultArn.map(value => value),
        recoveryPointArn.map(value => value),
        lifecycle.map(value => value.asEditable),
        calculatedLifecycle.map(value => value.asEditable)
      )
    def backupVaultArn: Option[ARN]
    def recoveryPointArn: Option[ARN]
    def lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly]
    def calculatedLifecycle
        : Option[zio.aws.backup.model.CalculatedLifecycle.ReadOnly]
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getCalculatedLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.CalculatedLifecycle.ReadOnly
    ] = AwsError.unwrapOptionField("calculatedLifecycle", calculatedLifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse
  ) extends zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly {
    override val backupVaultArn: Option[ARN] = scala
      .Option(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val recoveryPointArn: Option[ARN] = scala
      .Option(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val lifecycle: Option[zio.aws.backup.model.Lifecycle.ReadOnly] =
      scala
        .Option(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
    override val calculatedLifecycle
        : Option[zio.aws.backup.model.CalculatedLifecycle.ReadOnly] = scala
      .Option(impl.calculatedLifecycle())
      .map(value => zio.aws.backup.model.CalculatedLifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse
  ): zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly =
    new Wrapper(impl)
}
