package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  Timestamp,
  BackupSelectionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class BackupSelectionsListMember(
    selectionId: Optional[String] = Optional.Absent,
    selectionName: Optional[BackupSelectionName] = Optional.Absent,
    backupPlanId: Optional[String] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    creatorRequestId: Optional[String] = Optional.Absent,
    iamRoleArn: Optional[IAMRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupSelectionsListMember = {
    import BackupSelectionsListMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupSelectionsListMember
      .builder()
      .optionallyWith(selectionId.map(value => value: java.lang.String))(
        _.selectionId
      )
      .optionallyWith(
        selectionName.map(value =>
          BackupSelectionName.unwrap(value): java.lang.String
        )
      )(_.selectionName)
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupSelectionsListMember.ReadOnly =
    zio.aws.backup.model.BackupSelectionsListMember.wrap(buildAwsValue())
}
object BackupSelectionsListMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.BackupSelectionsListMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupSelectionsListMember =
      zio.aws.backup.model.BackupSelectionsListMember(
        selectionId.map(value => value),
        selectionName.map(value => value),
        backupPlanId.map(value => value),
        creationDate.map(value => value),
        creatorRequestId.map(value => value),
        iamRoleArn.map(value => value)
      )
    def selectionId: Optional[String]
    def selectionName: Optional[BackupSelectionName]
    def backupPlanId: Optional[String]
    def creationDate: Optional[Timestamp]
    def creatorRequestId: Optional[String]
    def iamRoleArn: Optional[IAMRoleArn]
    def getSelectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selectionId", selectionId)
    def getSelectionName: ZIO[Any, AwsError, BackupSelectionName] =
      AwsError.unwrapOptionField("selectionName", selectionName)
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupSelectionsListMember
  ) extends zio.aws.backup.model.BackupSelectionsListMember.ReadOnly {
    override val selectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionId())
      .map(value => value: String)
    override val selectionName: Optional[BackupSelectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectionName())
        .map(value =>
          zio.aws.backup.model.primitives.BackupSelectionName(value)
        )
    override val backupPlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => value: String)
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
    override val iamRoleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupSelectionsListMember
  ): zio.aws.backup.model.BackupSelectionsListMember.ReadOnly = new Wrapper(
    impl
  )
}
