package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait ConditionType {
  def unwrap: software.amazon.awssdk.services.backup.model.ConditionType
}
object ConditionType {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.ConditionType
  ): zio.aws.backup.model.ConditionType = value match {
    case software.amazon.awssdk.services.backup.model.ConditionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.ConditionType.STRINGEQUALS =>
      val r = STRINGEQUALS
      r
  }
  case object unknownToSdkVersion extends zio.aws.backup.model.ConditionType {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.ConditionType =
      software.amazon.awssdk.services.backup.model.ConditionType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRINGEQUALS extends zio.aws.backup.model.ConditionType {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.ConditionType =
      software.amazon.awssdk.services.backup.model.ConditionType.STRINGEQUALS
  }
}
