package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{TagValue, TagKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBackupPlanRequest(
    backupPlan: zio.aws.backup.model.BackupPlanInput,
    backupPlanTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    creatorRequestId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest = {
    import CreateBackupPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest
      .builder()
      .backupPlan(backupPlan.buildAwsValue())
      .optionallyWith(
        backupPlanTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.backupPlanTags)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateBackupPlanRequest.ReadOnly =
    zio.aws.backup.model.CreateBackupPlanRequest.wrap(buildAwsValue())
}
object CreateBackupPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateBackupPlanRequest =
      zio.aws.backup.model.CreateBackupPlanRequest(
        backupPlan.asEditable,
        backupPlanTags.map(value => value),
        creatorRequestId.map(value => value)
      )
    def backupPlan: zio.aws.backup.model.BackupPlanInput.ReadOnly
    def backupPlanTags: Optional[Map[TagKey, TagValue]]
    def creatorRequestId: Optional[String]
    def getBackupPlan
        : ZIO[Any, Nothing, zio.aws.backup.model.BackupPlanInput.ReadOnly] =
      ZIO.succeed(backupPlan)
    def getBackupPlanTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("backupPlanTags", backupPlanTags)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest
  ) extends zio.aws.backup.model.CreateBackupPlanRequest.ReadOnly {
    override val backupPlan: zio.aws.backup.model.BackupPlanInput.ReadOnly =
      zio.aws.backup.model.BackupPlanInput.wrap(impl.backupPlan())
    override val backupPlanTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlanTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives
                .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest
  ): zio.aws.backup.model.CreateBackupPlanRequest.ReadOnly = new Wrapper(impl)
}
