package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{FrameworkDescription, FrameworkName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFrameworkRequest(
    frameworkName: FrameworkName,
    frameworkDescription: Optional[FrameworkDescription] = Optional.Absent,
    frameworkControls: Iterable[zio.aws.backup.model.FrameworkControl],
    idempotencyToken: Optional[String] = Optional.Absent,
    frameworkTags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateFrameworkRequest = {
    import CreateFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateFrameworkRequest
      .builder()
      .frameworkName(FrameworkName.unwrap(frameworkName): java.lang.String)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .frameworkControls(frameworkControls.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(
        frameworkTags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.frameworkTags)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateFrameworkRequest.ReadOnly =
    zio.aws.backup.model.CreateFrameworkRequest.wrap(buildAwsValue())
}
object CreateFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateFrameworkRequest =
      zio.aws.backup.model.CreateFrameworkRequest(
        frameworkName,
        frameworkDescription.map(value => value),
        frameworkControls.map { item =>
          item.asEditable
        },
        idempotencyToken.map(value => value),
        frameworkTags.map(value => value)
      )
    def frameworkName: FrameworkName
    def frameworkDescription: Optional[FrameworkDescription]
    def frameworkControls: List[zio.aws.backup.model.FrameworkControl.ReadOnly]
    def idempotencyToken: Optional[String]
    def frameworkTags: Optional[Map[String, String]]
    def getFrameworkName: ZIO[Any, Nothing, FrameworkName] =
      ZIO.succeed(frameworkName)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getFrameworkControls: ZIO[Any, Nothing, List[
      zio.aws.backup.model.FrameworkControl.ReadOnly
    ]] = ZIO.succeed(frameworkControls)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getFrameworkTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("frameworkTags", frameworkTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateFrameworkRequest
  ) extends zio.aws.backup.model.CreateFrameworkRequest.ReadOnly {
    override val frameworkName: FrameworkName =
      zio.aws.backup.model.primitives.FrameworkName(impl.frameworkName())
    override val frameworkDescription: Optional[FrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkDescription())
        .map(value =>
          zio.aws.backup.model.primitives.FrameworkDescription(value)
        )
    override val frameworkControls
        : List[zio.aws.backup.model.FrameworkControl.ReadOnly] = impl
      .frameworkControls()
      .asScala
      .map { item =>
        zio.aws.backup.model.FrameworkControl.wrap(item)
      }
      .toList
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
    override val frameworkTags: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateFrameworkRequest
  ): zio.aws.backup.model.CreateFrameworkRequest.ReadOnly = new Wrapper(impl)
}
