package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBackupVaultRequest(backupVaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest = {
    import DeleteBackupVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest
      .builder()
      .backupVaultName(backupVaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteBackupVaultRequest.ReadOnly =
    zio.aws.backup.model.DeleteBackupVaultRequest.wrap(buildAwsValue())
}
object DeleteBackupVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteBackupVaultRequest =
      zio.aws.backup.model.DeleteBackupVaultRequest(backupVaultName)
    def backupVaultName: String
    def getBackupVaultName: ZIO[Any, Nothing, String] =
      ZIO.succeed(backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest
  ) extends zio.aws.backup.model.DeleteBackupVaultRequest.ReadOnly {
    override val backupVaultName: String = impl.backupVaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest
  ): zio.aws.backup.model.DeleteBackupVaultRequest.ReadOnly = new Wrapper(impl)
}
