package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.FrameworkName
import scala.jdk.CollectionConverters._
final case class DeleteFrameworkRequest(frameworkName: FrameworkName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest = {
    import DeleteFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest
      .builder()
      .frameworkName(FrameworkName.unwrap(frameworkName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteFrameworkRequest.ReadOnly =
    zio.aws.backup.model.DeleteFrameworkRequest.wrap(buildAwsValue())
}
object DeleteFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteFrameworkRequest =
      zio.aws.backup.model.DeleteFrameworkRequest(frameworkName)
    def frameworkName: FrameworkName
    def getFrameworkName: ZIO[Any, Nothing, FrameworkName] =
      ZIO.succeed(frameworkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest
  ) extends zio.aws.backup.model.DeleteFrameworkRequest.ReadOnly {
    override val frameworkName: FrameworkName =
      zio.aws.backup.model.primitives.FrameworkName(impl.frameworkName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest
  ): zio.aws.backup.model.DeleteFrameworkRequest.ReadOnly = new Wrapper(impl)
}
