package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.ReportPlanName
import scala.jdk.CollectionConverters._
final case class DeleteReportPlanRequest(reportPlanName: ReportPlanName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest = {
    import DeleteReportPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest
      .builder()
      .reportPlanName(ReportPlanName.unwrap(reportPlanName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteReportPlanRequest.ReadOnly =
    zio.aws.backup.model.DeleteReportPlanRequest.wrap(buildAwsValue())
}
object DeleteReportPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteReportPlanRequest =
      zio.aws.backup.model.DeleteReportPlanRequest(reportPlanName)
    def reportPlanName: ReportPlanName
    def getReportPlanName: ZIO[Any, Nothing, ReportPlanName] =
      ZIO.succeed(reportPlanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest
  ) extends zio.aws.backup.model.DeleteReportPlanRequest.ReadOnly {
    override val reportPlanName: ReportPlanName =
      zio.aws.backup.model.primitives.ReportPlanName(impl.reportPlanName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest
  ): zio.aws.backup.model.DeleteReportPlanRequest.ReadOnly = new Wrapper(impl)
}
