package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  AccountId,
  Timestamp,
  BackupVaultName,
  ResourceType,
  BackupOptionKey,
  BackupOptionValue,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeBackupJobResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    backupJobId: Optional[String] = Optional.Absent,
    backupVaultName: Optional[BackupVaultName] = Optional.Absent,
    backupVaultArn: Optional[ARN] = Optional.Absent,
    recoveryPointArn: Optional[ARN] = Optional.Absent,
    resourceArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    completionDate: Optional[Timestamp] = Optional.Absent,
    state: Optional[zio.aws.backup.model.BackupJobState] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    percentDone: Optional[String] = Optional.Absent,
    backupSizeInBytes: Optional[Long] = Optional.Absent,
    iamRoleArn: Optional[IAMRoleArn] = Optional.Absent,
    createdBy: Optional[zio.aws.backup.model.RecoveryPointCreator] =
      Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    bytesTransferred: Optional[Long] = Optional.Absent,
    expectedCompletionDate: Optional[Timestamp] = Optional.Absent,
    startBy: Optional[Timestamp] = Optional.Absent,
    backupOptions: Optional[Map[BackupOptionKey, BackupOptionValue]] =
      Optional.Absent,
    backupType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse = {
    import DescribeBackupJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(backupJobId.map(value => value: java.lang.String))(
        _.backupJobId
      )
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(percentDone.map(value => value: java.lang.String))(
        _.percentDone
      )
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(bytesTransferred.map(value => value: java.lang.Long))(
        _.bytesTransferred
      )
      .optionallyWith(
        expectedCompletionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expectedCompletionDate)
      .optionallyWith(startBy.map(value => Timestamp.unwrap(value): Instant))(
        _.startBy
      )
      .optionallyWith(
        backupOptions.map(value =>
          value
            .map({ case (key, value) =>
              (BackupOptionKey
                .unwrap(key): java.lang.String) -> (BackupOptionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.backupOptions)
      .optionallyWith(backupType.map(value => value: java.lang.String))(
        _.backupType
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly =
    zio.aws.backup.model.DescribeBackupJobResponse.wrap(buildAwsValue())
}
object DescribeBackupJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeBackupJobResponse =
      zio.aws.backup.model.DescribeBackupJobResponse(
        accountId.map(value => value),
        backupJobId.map(value => value),
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        recoveryPointArn.map(value => value),
        resourceArn.map(value => value),
        creationDate.map(value => value),
        completionDate.map(value => value),
        state.map(value => value),
        statusMessage.map(value => value),
        percentDone.map(value => value),
        backupSizeInBytes.map(value => value),
        iamRoleArn.map(value => value),
        createdBy.map(value => value.asEditable),
        resourceType.map(value => value),
        bytesTransferred.map(value => value),
        expectedCompletionDate.map(value => value),
        startBy.map(value => value),
        backupOptions.map(value => value),
        backupType.map(value => value)
      )
    def accountId: Optional[AccountId]
    def backupJobId: Optional[String]
    def backupVaultName: Optional[BackupVaultName]
    def backupVaultArn: Optional[ARN]
    def recoveryPointArn: Optional[ARN]
    def resourceArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def completionDate: Optional[Timestamp]
    def state: Optional[zio.aws.backup.model.BackupJobState]
    def statusMessage: Optional[String]
    def percentDone: Optional[String]
    def backupSizeInBytes: Optional[Long]
    def iamRoleArn: Optional[IAMRoleArn]
    def createdBy: Optional[zio.aws.backup.model.RecoveryPointCreator.ReadOnly]
    def resourceType: Optional[ResourceType]
    def bytesTransferred: Optional[Long]
    def expectedCompletionDate: Optional[Timestamp]
    def startBy: Optional[Timestamp]
    def backupOptions: Optional[Map[BackupOptionKey, BackupOptionValue]]
    def backupType: Optional[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getBackupJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupJobId", backupJobId)
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getState: ZIO[Any, AwsError, zio.aws.backup.model.BackupJobState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getPercentDone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentDone", percentDone)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointCreator.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getBytesTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesTransferred", bytesTransferred)
    def getExpectedCompletionDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("expectedCompletionDate", expectedCompletionDate)
    def getStartBy: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startBy", startBy)
    def getBackupOptions
        : ZIO[Any, AwsError, Map[BackupOptionKey, BackupOptionValue]] =
      AwsError.unwrapOptionField("backupOptions", backupOptions)
    def getBackupType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupType", backupType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
  ) extends zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val backupJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupJobId())
      .map(value => value: String)
    override val backupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val state: Optional[zio.aws.backup.model.BackupJobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.backup.model.BackupJobState.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val percentDone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.percentDone())
      .map(value => value: String)
    override val backupSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.backupSizeInBytes())
      .map(value => value: Long)
    override val iamRoleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val createdBy
        : Optional[zio.aws.backup.model.RecoveryPointCreator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.backup.model.RecoveryPointCreator.wrap(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val bytesTransferred: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesTransferred())
      .map(value => value: Long)
    override val expectedCompletionDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedCompletionDate())
        .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val startBy: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startBy())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val backupOptions
        : Optional[Map[BackupOptionKey, BackupOptionValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives.BackupOptionKey(
                key
              ) -> zio.aws.backup.model.primitives.BackupOptionValue(value)
            })
            .toMap
        )
    override val backupType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse
  ): zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly = new Wrapper(impl)
}
