package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  Timestamp,
  GlobalSettingsValue,
  GlobalSettingsName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeGlobalSettingsResponse(
    globalSettings: Optional[Map[GlobalSettingsName, GlobalSettingsValue]] =
      Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse = {
    import DescribeGlobalSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse
      .builder()
      .optionallyWith(
        globalSettings.map(value =>
          value
            .map({ case (key, value) =>
              (GlobalSettingsName
                .unwrap(key): java.lang.String) -> (GlobalSettingsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.globalSettings)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly =
    zio.aws.backup.model.DescribeGlobalSettingsResponse.wrap(buildAwsValue())
}
object DescribeGlobalSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeGlobalSettingsResponse =
      zio.aws.backup.model.DescribeGlobalSettingsResponse(
        globalSettings.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def globalSettings: Optional[Map[GlobalSettingsName, GlobalSettingsValue]]
    def lastUpdateTime: Optional[Timestamp]
    def getGlobalSettings
        : ZIO[Any, AwsError, Map[GlobalSettingsName, GlobalSettingsValue]] =
      AwsError.unwrapOptionField("globalSettings", globalSettings)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse
  ) extends zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly {
    override val globalSettings
        : Optional[Map[GlobalSettingsName, GlobalSettingsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalSettings())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives.GlobalSettingsName(
                key
              ) -> zio.aws.backup.model.primitives.GlobalSettingsValue(value)
            })
            .toMap
        )
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse
  ): zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
