package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.{ARN, BackupVaultName}
import scala.jdk.CollectionConverters._
final case class DescribeRecoveryPointRequest(
    backupVaultName: BackupVaultName,
    recoveryPointArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest = {
    import DescribeRecoveryPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeRecoveryPointRequest.ReadOnly =
    zio.aws.backup.model.DescribeRecoveryPointRequest.wrap(buildAwsValue())
}
object DescribeRecoveryPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeRecoveryPointRequest =
      zio.aws.backup.model
        .DescribeRecoveryPointRequest(backupVaultName, recoveryPointArn)
    def backupVaultName: BackupVaultName
    def recoveryPointArn: ARN
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest
  ) extends zio.aws.backup.model.DescribeRecoveryPointRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest
  ): zio.aws.backup.model.DescribeRecoveryPointRequest.ReadOnly = new Wrapper(
    impl
  )
}
